create or replace package emb_string as
    type string_array is table of varchar2(32767);
    function split_string(str in varchar2, delimiter in char default ',') return string_array;
end emb_string; 
/

create or replace package body emb_string as
    function split_string(str in varchar2, delimiter in char default ',') return string_array is
        return_value         string_array := string_array();
        split_str            long default str || delimiter;
        i                    number;
    begin
        loop
            i := instr(split_str, delimiter);
            exit when nvl(i,0) = 0;
            return_value.extend;
            return_value(return_value.count) := trim(substr(split_str, 1, i-1));
            split_str := substr(split_str, i + length(delimiter));
        end loop;
        return return_value;
    end split_string;
end emb_string; 
/
/* ****************************************************************************************************** */
create or replace PACKAGE types
AS
    TYPE ref_cursor IS REF CURSOR;
END; 	
/
/* ****************************************************************************************************** */
COMMIT;
